import java.io.*;
import java.net.*;
import java.rmi.*;
import java.util.*;
import java.rmi.server.*;
import java.rmi.registry.LocateRegistry;
import java.sql.ResultSet;

/**
 * Server. En klasse der giver klienter adgang til at bruge metoder i klassen
 * NetScore_controller via NetScore_interface.
 **/
 
public class Server
{	
	private String server_port;
	private Properties prop;
	private FileInputStream input;
	
	private Connection_controller in_Connection_controller;
	
	/**
	 * Konstruktr, instansierer en ArrayList der huser interfaces brugt af
	 * klienter, indlser informationer fra .property -filen og instansierer
	 * et objekt fra klassen DB_tool
	 **/
	 
	public Server()
	{		
		try
	 	{
	 		prop = new Properties();
	 		input = new FileInputStream("Server.properties");
	 		prop.load(input);
	 		server_port = prop.getProperty("SERVER_PORT");	 			 			 			 		
	 	}
	 	
	 	catch(IOException err)
	 	{
	 		System.out.println("ERROR: can't connect to .property -file " + err);	 		
	 	}
	}
    
	/**
	 * Method to start the server
	 **/
	 
	public void start() throws RemoteException
	{
		LocateRegistry.createRegistry(Integer.parseInt(server_port));
		
		try
		{
			in_Connection_controller = new Connection_controller(this);				
			Naming.rebind("rmi://localhost:"+server_port+"/Connection_service",in_Connection_controller);
			System.out.println("Server has started\n");
		}
		
		catch(MalformedURLException err)
		{
			System.out.println("ERROR: Server failed to start " + err);
		}
	}
	
	/**
	 * Method to stop the Server
	 **/
	 
	public void stop() throws RemoteException
	{
		System.out.println("Server has stopped");
		
		System.exit(0);
	}
	
	/**
	 * Main to start Server
	 **/
	
	public static void main(String args[])
	{
		try
		{
			Server serv = new Server();
			serv.start();
		}
		catch(Exception err)
		{
			err.printStackTrace();
		}
	}
}